/* A polyfill for browsers that don't support ligatures. */
/* The script tag referring to this file must be placed before the ending body tag. */

/* To provide support for elements dynamically added, this script adds
   method 'icomoonLiga' to the window object. You can pass element references to this method.
*/
(function () {
	'use strict';
	function supportsProperty(p) {
		var prefixes = ['Webkit', 'Moz', 'O', 'ms'],
			i,
			div = document.createElement('div'),
			ret = p in div.style;
		if (!ret) {
			p = p.charAt(0).toUpperCase() + p.substr(1);
			for (i = 0; i < prefixes.length; i += 1) {
				ret = prefixes[i] + p in div.style;
				if (ret) {
					break;
				}
			}
		}
		return ret;
	}
	var icons;
	if (!supportsProperty('fontFeatureSettings')) {
		icons = {
			'home2': '&#xe601;',
			'building2': '&#xe601;',
			'couch': '&#xe609;',
			'furniture': '&#xe609;',
			'city': '&#xe60b;',
			'building7': '&#xe60b;',
			'apartment': '&#xe60c;',
			'building8': '&#xe60c;',
			'pencil': '&#xe60d;',
			'write': '&#xe60d;',
			'pen': '&#xe60f;',
			'write3': '&#xe60f;',
			'eraser': '&#xe611;',
			'rubber': '&#xe611;',
			'pencil5': '&#xe613;',
			'write6': '&#xe613;',
			'pen2': '&#xe617;',
			'write10': '&#xe617;',
			'vector': '&#xe61a;',
			'bezier': '&#xe61a;',
			'brush': '&#xe61d;',
			'paint': '&#xe61d;',
			'brush2': '&#xe61e;',
			'paint2': '&#xe61e;',
			'stamp': '&#xe621;',
			'rubber-stamp': '&#xe621;',
			'palette': '&#xe626;',
			'design2': '&#xe626;',
			'color-sampler': '&#xe627;',
			'design3': '&#xe627;',
			'bucket': '&#xe628;',
			'paint5': '&#xe628;',
			'magic-wand': '&#xe62b;',
			'tool': '&#xe62b;',
			'pencil-ruler': '&#xe62d;',
			'design4': '&#xe62d;',
			'pencil-ruler2': '&#xe62e;',
			'design5': '&#xe62e;',
			'database-lock': '&#xe660;',
			'database4': '&#xe660;',
			'server': '&#xe666;',
			'hosting': '&#xe666;',
			'shield': '&#xe667;',
			'security': '&#xe667;',
			'lock': '&#xe66b;',
			'privacy': '&#xe66b;',
			'toggle-off': '&#xe670;',
			'toggle': '&#xe670;',
			'hammer-wrench': '&#xe676;',
			'tool6': '&#xe676;',
			'recycle': '&#xe67f;',
			'trash2': '&#xe681;',
			'bin2': '&#xe681;',
			'mailbox-full': '&#xe693;',
			'mailbox': '&#xe693;',
			'at-sign': '&#xe695;',
			'mail': '&#xe695;',
			'envelope': '&#xe696;',
			'mail2': '&#xe696;',
			'envelope-open': '&#xe697;',
			'mail3': '&#xe697;',
			'paper-plane': '&#xe699;',
			'mail4': '&#xe699;',
			'reply': '&#xe69a;',
			'left': '&#xe69a;',
			'box': '&#xe69f;',
			'storage2': '&#xe69f;',
			'eye': '&#xe6a5;',
			'vision': '&#xe6a5;',
			'hdd': '&#xe6ab;',
			'storage3': '&#xe6ab;',
			'printer': '&#xe6b1;',
			'print': '&#xe6b1;',
			'clipboard-text': '&#xe6cb;',
			'clipboard4': '&#xe6cb;',
			'register': '&#xe6d1;',
			'signature': '&#xe6d1;',
			'medal-empty': '&#xe6dd;',
			'medal': '&#xe6dd;',
			'trophy': '&#xe6e2;',
			'cup': '&#xe6e2;',
			'equalizer': '&#xe6f2;',
			'settings': '&#xe6f2;',
			'camera': '&#xe6ff;',
			'video5': '&#xe6ff;',
			'camera2': '&#xe704;',
			'photo2': '&#xe704;',
			'picture': '&#xe70e;',
			'photo5': '&#xe70e;',
			'bookmark2': '&#xe716;',
			'ribbon': '&#xe716;',
			'portrait': '&#xe71c;',
			'photo9': '&#xe71c;',
			'user': '&#xe71e;',
			'persona': '&#xe71e;',
			'barcode3': '&#xe749;',
			'price3': '&#xe749;',
			'cashier': '&#xe74a;',
			'checkout': '&#xe74a;',
			'bag': '&#xe74b;',
			'shop3': '&#xe74b;',
			'bag2': '&#xe74c;',
			'shop4': '&#xe74c;',
			'tags': '&#xe756;',
			'price5': '&#xe756;',
			'receipt': '&#xe757;',
			'price6': '&#xe757;',
			'wallet': '&#xe758;',
			'money': '&#xe758;',
			'credit-card': '&#xe759;',
			'money2': '&#xe759;',
			'bag-dollar': '&#xe75e;',
			'money7': '&#xe75e;',
			'bag-euro': '&#xe75f;',
			'money8': '&#xe75f;',
			'phone-wave': '&#xe76c;',
			'phone3': '&#xe76c;',
			'telephone2': '&#xe777;',
			'phone12': '&#xe777;',
			'map-marker-check': '&#xe77d;',
			'pin6': '&#xe77d;',
			'map': '&#xe781;',
			'guide2': '&#xe781;',
			'mouse': '&#xe78d;',
			'click': '&#xe78d;',
			'mouse-left': '&#xe78e;',
			'click2': '&#xe78e;',
			'mouse-right': '&#xe78f;',
			'click3': '&#xe78f;',
			'smartphone': '&#xe7a6;',
			'mobile2': '&#xe7a6;',
			'smartphone-embed': '&#xe7a9;',
			'mobile5': '&#xe7a9;',
			'tablet2': '&#xe7ac;',
			'mobile8': '&#xe7ac;',
			'laptop-phone': '&#xe7ae;',
			'devices': '&#xe7ae;',
			'desktop': '&#xe7af;',
			'computer2': '&#xe7af;',
			'cable': '&#xe7b3;',
			'plug': '&#xe7b3;',
			'power': '&#xe7b9;',
			'lightning': '&#xe7b9;',
			'lamp': '&#xe7bc;',
			'light': '&#xe7bc;',
			'battery-mid1': '&#xe7c8;',
			'battery8': '&#xe7c8;',
			'battery-charging': '&#xe7cc;',
			'battery12': '&#xe7cc;',
			'chip': '&#xe7d3;',
			'cpu': '&#xe7d3;',
			'bubble': '&#xe7d6;',
			'chat': '&#xe7d6;',
			'bubbles': '&#xe7d7;',
			'chat2': '&#xe7d7;',
			'phone-bubble': '&#xe7e4;',
			'phone14': '&#xe7e4;',
			'lifebuoy': '&#xe7ed;',
			'help': '&#xe7ed;',
			'beaker': '&#xe7f3;',
			'lab2': '&#xe7f3;',
			'graph': '&#xe7fa;',
			'chart3': '&#xe7fa;',
			'gift': '&#xe7ff;',
			'birthday2': '&#xe7ff;',
			'diamond': '&#xe806;',
			'jewelry': '&#xe806;',
			'rocket': '&#xe837;',
			'spaceship': '&#xe837;',
			'briefcase': '&#xe83a;',
			'suitcase': '&#xe83a;',
			'bicycle2': '&#xe860;',
			'exercise': '&#xe860;',
			'fence': '&#xe87c;',
			'wall2': '&#xe87c;',
			'wall3': '&#xe87d;',
			'bricks2': '&#xe87d;',
			'earth': '&#xe884;',
			'globe': '&#xe884;',
			'happy': '&#xe889;',
			'emoticon': '&#xe889;',
			'mustache-glasses': '&#xe8a8;',
			'hipster2': '&#xe8a8;',
			'satellite2': '&#xe8ca;',
			'antenna2': '&#xe8ca;',
			'return2': '&#xe8e1;',
			'backward2': '&#xe8e1;',
			'refund': '&#xe8e2;',
			'return3': '&#xe8e2;',
			'clock': '&#xe8e6;',
			'time': '&#xe8e6;',
			'alarm-check': '&#xe8ed;',
			'time8': '&#xe8ed;',
			'timer': '&#xe8ef;',
			'time10': '&#xe8ef;',
			'cli': '&#xe909;',
			'console': '&#xe909;',
			'file-code': '&#xe90c;',
			'file7': '&#xe90c;',
			'file-zip': '&#xe90e;',
			'file9': '&#xe90e;',
			'link2': '&#xe917;',
			'url3': '&#xe917;',
			'unlink2': '&#xe918;',
			'url4': '&#xe918;',
			'thumbs-up3': '&#xe91d;',
			'like3': '&#xe91d;',
			'find-replace': '&#xe924;',
			'search2': '&#xe924;',
			'menu3': '&#xe931;',
			'dropdown': '&#xe931;',
			'chevron-left': '&#xe93b;',
			'left8': '&#xe93b;',
			'chevron-right': '&#xe93c;',
			'right6': '&#xe93c;',
			'transform': '&#xe974;',
			'bounding-box': '&#xe974;',
			'angle2': '&#xe982;',
			'measurement2': '&#xe982;',
			'check-square': '&#xe999;',
			'checkmark3': '&#xe999;',
			'gesture-zoom': '&#xe9c9;',
			'hand11': '&#xe9c9;',
			'fingers-scroll-right': '&#xe9ce;',
			'hand16': '&#xe9ce;',
			'pointer-up2': '&#xe9d0;',
			'hand18': '&#xe9d0;',
			'finger-tap2': '&#xe9d4;',
			'hand22': '&#xe9d4;',
			'0': 0
		};
		delete icons['0'];
		window.icomoonLiga = function (els) {
			var classes,
				el,
				i,
				innerHTML,
				key;
			els = els || document.getElementsByTagName('*');
			if (!els.length) {
				els = [els];
			}
			for (i = 0; ; i += 1) {
				el = els[i];
				if (!el) {
					break;
				}
				classes = el.className;
				if (/icon-/.test(classes)) {
					innerHTML = el.innerHTML;
					if (innerHTML && innerHTML.length > 1) {
						for (key in icons) {
							if (icons.hasOwnProperty(key)) {
								innerHTML = innerHTML.replace(new RegExp(key, 'g'), icons[key]);
							}
						}
						el.innerHTML = innerHTML;
					}
				}
			}
		};
		window.icomoonLiga();
	}
}());